/*
 * Decompiled with CFR 0.152.
 */
package com.aql.util;

import com.aql.SensorPropertiesFrame;
import com.aql.util.Command;
import com.aql.util.SensorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;

public class SensorCommand
implements Command {
    private byte command;
    private SensorProperties sensor;

    public SensorCommand(byte by, SensorProperties sensorProperties) {
        this.command = by;
        this.sensor = sensorProperties;
    }

    public byte getCommand() {
        return this.command;
    }

    public SensorProperties getOzoneSensor() {
        return this.sensor;
    }

    public static void sendCommand(SensorCommand sensorCommand) throws IOException {
        byte[] byArray = new byte[5];
        byArray[0] = 85;
        byArray[1] = sensorCommand.getCommand();
        byArray[2] = (byte)sensorCommand.getOzoneSensor().getSensorId();
        byArray[4] = SensorCommand.getCheckSum(byArray);
        System.out.println("Send Sensor Command: " + SensorCommand.convertToHexString(byArray, 5));
        OutputStream outputStream = SensorPropertiesFrame.commPort.getOutputStream();
        outputStream.flush();
        outputStream.write(byArray);
        outputStream.flush();
    }

    public static void sendCommand(byte by, int n) throws IOException {
        byte[] byArray = new byte[5];
        byArray[0] = 85;
        byArray[1] = by;
        byArray[2] = (byte)n;
        byArray[4] = SensorCommand.getCheckSum(byArray);
        System.out.println("Send Sensor Command: " + SensorCommand.convertToHexString(byArray, 5));
        OutputStream outputStream = SensorPropertiesFrame.commPort.getOutputStream();
        outputStream.flush();
        outputStream.write(byArray);
        outputStream.flush();
    }

    public static byte[] convertUIDToByte(int n) {
        int n2;
        String string = Integer.toHexString(n);
        if (string.length() < 8) {
            int n3 = 8 - string.length();
            for (n2 = 0; n2 < n3; ++n2) {
                string = "0" + string;
            }
        }
        byte[] byArray = new byte[4];
        for (n2 = 0; n2 < 4; ++n2) {
            byArray[n2] = Integer.valueOf(string.substring(n2 * 2, n2 * 2 + 2), 16).byteValue();
        }
        return byArray;
    }

    public static int convertUIDToInt(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            n2 = 0xFF & byArray[i];
            n |= n2;
            if (i >= 3) continue;
            n &= (int)(Math.pow(2.0, (double)(i + 1) * 8.0) - 1.0);
            n <<= 8;
        }
        return n;
    }

    public static byte getCheckSum(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length - 1; ++i) {
            n = (byte)(n + byArray[i]);
        }
        return (byte)(n * -1);
    }

    public static boolean checkSumCorrect(byte[] byArray) {
        byte by = 0;
        for (int i = 0; i < byArray.length; ++i) {
            by = (byte)(by + byArray[i]);
        }
        return by == 0;
    }

    public static byte[] toByteArray(float f) {
        byte[] byArray = new byte[4];
        int n = Float.floatToIntBits(f);
        for (int i = 0; i < 4; ++i) {
            byArray[i] = (byte)(n & 0xFF);
            n >>= 8;
        }
        return byArray;
    }

    public static byte[] toByteArray(int n) {
        byte[] byArray = new byte[4];
        for (int i = 0; i < 4; ++i) {
            byArray[i] = (byte)(n & 0xFF);
            n >>= 8;
        }
        String string = SensorCommand.convertToHexString(byArray, 4);
        return byArray;
    }

    public static byte[] toByteArray(short s) {
        byte[] byArray = new byte[2];
        for (int i = 0; i < 2; ++i) {
            byArray[i] = (byte)(s & 0xFF);
            s = (short)(s >> 8);
        }
        String string = SensorCommand.convertToHexString(byArray, 2);
        return byArray;
    }

    public static byte[] toByteArray(Calendar calendar) {
        byte[] byArray = new byte[4];
        int n = calendar.get(1) - 2000;
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        int n4 = calendar.get(11);
        int n5 = calendar.get(12);
        int n6 = calendar.get(13);
        n <<= 4;
        n |= n2;
        n <<= 5;
        n |= n3;
        n <<= 5;
        n |= n4;
        n <<= 6;
        n |= n5;
        n <<= 6;
        byArray = SensorCommand.toByteArray(n |= n6);
        return byArray;
    }

    public static float convertToValue(byte[] byArray, int n, int n2) throws NumberFormatException {
        int n3 = 0;
        int n4 = 0;
        for (int i = n2; i > n; --i) {
            n3 <<= 8;
            n4 = byArray[i];
            n3 |= (n4 &= 0xFF);
        }
        float f = Float.intBitsToFloat(n3);
        System.out.println("The value :" + f);
        return f;
    }

    public static int getFieldValue(int n, int n2) {
        switch (n2) {
            case 5: {
                return SensorCommand.getValue(n, 26, 32);
            }
            case 4: {
                return SensorCommand.getValue(n, 22, 26);
            }
            case 3: {
                return SensorCommand.getValue(n, 17, 22);
            }
            case 2: {
                return SensorCommand.getValue(n, 12, 17);
            }
            case 1: {
                return SensorCommand.getValue(n, 6, 12);
            }
            case 0: {
                return SensorCommand.getValue(n, 0, 6);
            }
        }
        return 0;
    }

    private static int getValue(int n, int n2, int n3) {
        n >>= n2;
        return n &= SensorCommand.getMaskValue(n2, n3);
    }

    private static int getMaskValue(int n, int n2) {
        switch (n2 - n) {
            case 4: {
                return 15;
            }
            case 5: {
                return 31;
            }
            case 6: {
                return 63;
            }
        }
        return 0;
    }

    public static int byteToIntValue(byte by) {
        int n = 0;
        n |= by;
        return n &= 0xFF;
    }

    public static byte[] toByteArray(long l) {
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        String string = SensorCommand.convertToHexString(byArray, 8);
        return byArray;
    }

    public static String convertToHexString(byte[] byArray, int n) {
        String string = "0x";
        for (int i = 0; i < n; ++i) {
            string = string + " " + SensorCommand.convertToHexString(byArray[i]);
        }
        return string;
    }

    public static String convertToHexStringNoBlank(byte[] byArray, int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + SensorCommand.convertToHexString(byArray[i]);
        }
        return string;
    }

    public static String convertToHexString(byte n) {
        int n2 = 0;
        n2 = n;
        String string = Integer.toHexString(n2 &= 0xFF).toUpperCase();
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string;
    }
}

