/*
 * Decompiled with CFR 0.152.
 */
package com.aql.util;

import com.aql.ProgressWindow;
import com.aql.SensorPropertiesFrame;
import com.aql.rs232.CommPortCreator;
import com.aql.util.Command;
import com.aql.util.SensorCommand;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class SearchNetworkThread
extends Thread {
    private SensorPropertiesFrame parent;
    private CommPortCreator commPort;
    private ProgressWindow progressWin;
    private int startID = 1;
    private int endID = 255;
    private int groupID = 0;

    public SearchNetworkThread(SensorPropertiesFrame sensorPropertiesFrame) {
        this.parent = sensorPropertiesFrame;
        this.commPort = SensorPropertiesFrame.commPort;
        this.progressWin = new ProgressWindow(sensorPropertiesFrame, "Searching network port, please wait...");
    }

    public SearchNetworkThread(SensorPropertiesFrame sensorPropertiesFrame, int n, int n2, int n3) {
        this.parent = sensorPropertiesFrame;
        this.commPort = SensorPropertiesFrame.commPort;
        this.startID = n;
        this.endID = n2;
        this.groupID = n3;
        this.progressWin = new ProgressWindow(sensorPropertiesFrame, "Searching network port, please wait...");
    }

    @Override
    public void run() {
        try {
            Vector vector = new Vector();
            for (int i = this.startID; i <= this.endID; ++i) {
                System.out.println("Search for port: " + i);
                SensorCommand.sendCommand((byte)-5, i);
                if (!this.replyed(i)) continue;
                System.out.println("Found port : " + i);
                this.parent.setFoundID(i);
                break;
            }
            this.progressWin.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private synchronized boolean replyed(int n) {
        byte[] byArray = new byte[15];
        byte[] byArray2 = new byte[1];
        boolean bl = false;
        InputStream inputStream = this.commPort.getInputStream();
        try {
            for (int i = 0; i < 10; ++i) {
                while (inputStream.available() > 0) {
                    int n2 = inputStream.read(byArray2);
                    if (byArray2[0] == Command.SENSOR) {
                        byArray[0] = byArray2[0];
                        while (inputStream.available() > 0 && n2 < byArray.length) {
                            n2 += inputStream.read(byArray, n2, byArray.length - n2);
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception exception) {}
                        }
                        System.out.println("The data received: " + SensorCommand.convertToHexString(byArray, n2) + " The data length got:" + n2 + " bytes");
                        if (n2 != byArray.length) continue;
                        bl = true;
                        return bl;
                    }
                    System.out.println("Communication not synchronised...");
                }
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return bl;
        }
        catch (IOException iOException) {
            System.out.println("SensorConnectionTestThread: " + iOException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }
}

