/*
 * Decompiled with CFR 0.152.
 */
package com.aql.util;

import com.aql.ProgressWindow;
import com.aql.SensorPropertiesFrame;
import com.aql.rs232.CommPortCreator;
import com.aql.util.Command;
import com.aql.util.SensorCommand;
import java.io.IOException;
import java.io.InputStream;

public class DownloadParametersThread
extends Thread {
    private SensorPropertiesFrame parent;
    private CommPortCreator commPort;
    private ProgressWindow progressWin;
    private int ID = 1;

    public DownloadParametersThread(SensorPropertiesFrame sensorPropertiesFrame) {
        this.parent = sensorPropertiesFrame;
        this.commPort = SensorPropertiesFrame.commPort;
        this.progressWin = new ProgressWindow(sensorPropertiesFrame, "Downloading sensor parameters, please wait...");
    }

    @Override
    public void run() {
        try {
            System.out.println("Download sensor parameters...");
            if (this.replyed()) {
                this.parent.setFoundID(1);
            }
            this.progressWin.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private synchronized boolean replyed() {
        byte[] byArray = new byte[50];
        byte[] byArray2 = new byte[1];
        boolean bl = false;
        InputStream inputStream = this.commPort.getInputStream();
        try {
            for (int i = 0; i < 10; ++i) {
                while (inputStream.available() > 0) {
                    int n = inputStream.read(byArray2);
                    if (byArray2[0] == Command.SENSOR) {
                        byArray[0] = byArray2[0];
                        while (inputStream.available() > 0 && n < byArray.length) {
                            n += inputStream.read(byArray, n, byArray.length - n);
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception exception) {}
                        }
                        System.out.println("The data received: " + SensorCommand.convertToHexString(byArray, n) + " The data length got:" + n + " bytes");
                        if (n != byArray.length) continue;
                        bl = true;
                        return bl;
                    }
                    System.out.println("Communication not synchronised...");
                }
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return bl;
        }
        catch (IOException iOException) {
            System.out.println("SensorConnectionTestThread: " + iOException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }
}

