/*
 * Decompiled with CFR 0.152.
 */
package com.aql.rs232;

import com.aql.SensorPropertiesFrame;
import com.aql.util.Command;
import com.aql.util.SensorCommand;
import com.aql.util.SensorParameters;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JOptionPane;

public class SensorParameterUploadThread
extends Thread {
    private SensorPropertiesFrame parent;
    private SensorParameters param;
    private byte networkID;

    public SensorParameterUploadThread(SensorPropertiesFrame sensorPropertiesFrame, byte by, SensorParameters sensorParameters) {
        this.parent = sensorPropertiesFrame;
        this.networkID = by;
        this.param = sensorParameters;
    }

    @Override
    public void run() {
        try {
            int n;
            InputStream inputStream = SensorPropertiesFrame.commPort.getInputStream();
            OutputStream outputStream = SensorPropertiesFrame.commPort.getOutputStream();
            byte[] byArray = new byte[5];
            byArray[0] = 85;
            byArray[1] = 41;
            byArray[2] = this.networkID;
            byArray[4] = SensorCommand.getCheckSum(byArray);
            System.out.println("Send Command: " + SensorCommand.convertToHexString(byArray, 5));
            outputStream.flush();
            outputStream.write(byArray);
            outputStream.flush();
            int n2 = 52;
            byte[] byArray2 = new byte[n2];
            byArray2[0] = 85;
            byArray2[1] = 41;
            byArray2[2] = this.networkID;
            byte[] byArray3 = this.param.toByteArray();
            for (n = 0; n < byArray3.length; ++n) {
                byArray2[3 + n] = byArray3[n];
            }
            byArray2[n2 - 1] = SensorCommand.getCheckSum(byArray2);
            outputStream.write(byArray2);
            outputStream.flush();
            System.out.println("upload params: " + SensorCommand.convertToHexString(byArray2, byArray2.length));
            n = 0;
            while (inputStream.available() == 0 && n++ < 10) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {}
            }
            this.parent.closeProgress();
            if (inputStream.available() > 0) {
                inputStream.read(byArray);
                if (byArray[0] == Command.SENSOR && byArray[1] == 41) {
                    System.out.println("Param upload success." + SensorCommand.convertToHexString(byArray, 4));
                    JOptionPane.showMessageDialog(this.parent, "Calibrate sensor gain success.");
                } else {
                    JOptionPane.showMessageDialog(this.parent, "Calibrate sensor gain failed, please try later.");
                }
            } else {
                System.out.println("Upload failed, please try later.");
                JOptionPane.showMessageDialog(this.parent, "Calibarte sensor gain failed, please try later.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

