/*
 * Decompiled with CFR 0.152.
 */
package com.aql.rs232;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TooManyListenersException;
import javax.comm.CommPortIdentifier;
import javax.comm.CommPortOwnershipListener;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class CommPortCreator
implements SerialPortEventListener,
CommPortOwnershipListener {
    private Properties property = new Properties();
    private boolean waiting = false;
    private boolean openned = false;
    private Thread receivThread = null;
    private CommPortIdentifier portID;
    private SerialPort serialPort;
    private InputStream in;
    private OutputStream out;
    private ResourceBundle resources;

    public CommPortCreator() {
        this.initComPort();
    }

    public void initComPort() {
        try {
            File file = new File(".");
            String string = file.getAbsolutePath() + "\\resources\\";
            FileInputStream fileInputStream = new FileInputStream(string + "parameter.ini");
            this.property.load(fileInputStream);
            String string2 = this.property.getProperty("port");
            int n = Integer.parseInt(this.property.getProperty("baud_rate"));
            int n2 = Integer.parseInt(this.property.getProperty("data_bits"));
            String string3 = this.property.getProperty("stop_bits").trim();
            int n3 = this.getStopBitValue(string3);
            String string4 = this.property.getProperty("parity");
            int n4 = this.getParityValue(string4);
            System.out.println("port: " + string2 + ", baud rate: " + n + ", data bits: " + n2 + ", stop bits: " + n3 + ", parity: " + string4);
            fileInputStream.close();
            if (this.openned) {
                this.closeSerialPort();
            }
            this.createComPort(string2, n, n2, n3, n4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.createComPort("COM1", 2400, 8, 1, 0);
        }
    }

    private void createComPort(String string, int n, int n2, int n3, int n4) {
        try {
            this.portID = CommPortIdentifier.getPortIdentifier(string);
            this.portID.addPortOwnershipListener(this);
            String string2 = "S900 properties";
            this.serialPort = (SerialPort)this.portID.open(string2, 5000);
            this.serialPort.setSerialPortParams(n, n2, n3, n4);
            this.in = this.serialPort.getInputStream();
            this.out = this.serialPort.getOutputStream();
            try {
                this.serialPort.addEventListener(this);
            }
            catch (TooManyListenersException tooManyListenersException) {
                tooManyListenersException.printStackTrace();
            }
            this.serialPort.notifyOnCTS(true);
            this.serialPort.notifyOnDSR(true);
            this.serialPort.notifyOnRingIndicator(true);
            this.serialPort.notifyOnCarrierDetect(true);
            this.serialPort.notifyOnOverrunError(true);
            this.serialPort.notifyOnParityError(true);
            this.serialPort.notifyOnFramingError(true);
            this.serialPort.notifyOnBreakInterrupt(true);
            this.serialPort.notifyOnDataAvailable(true);
            this.serialPort.notifyOnOutputEmpty(true);
            this.openned = true;
            this.waiting = false;
        }
        catch (NoSuchPortException noSuchPortException) {
            System.err.println(noSuchPortException.getMessage());
            noSuchPortException.printStackTrace();
            String string3 = "Warning";
            JOptionPane.showMessageDialog(new JFrame(), "The Machine don't have such port: " + string + "\nPlease select a working COM port via System menu.", string3, 2);
        }
        catch (PortInUseException portInUseException) {
            String string4 = "Warning";
            JOptionPane.showMessageDialog(new JFrame(), this.portID.getName() + " " + portInUseException.getMessage(), string4, 2);
            this.waiting = true;
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            System.err.println(unsupportedCommOperationException.getMessage());
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
    }

    private int getStopBitValue(String string) {
        int n = 0;
        n = string.equals("1") ? 1 : (string.equals("1.5") ? 3 : 2);
        return n;
    }

    private int getParityValue(String string) {
        int n = 0;
        if (string.equals("None")) {
            n = 0;
        } else if (string.equals("Odd")) {
            n = 1;
        } else if (string.equals("Even")) {
            n = 2;
        }
        return n;
    }

    public SerialPort getSerialPort() {
        return this.serialPort;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public boolean isPortOpenned() {
        return this.openned;
    }

    public void closeSerialPort() {
        if (!this.openned) {
            return;
        }
        this.openned = false;
        this.serialPort.removeEventListener();
        this.portID.removePortOwnershipListener(this);
        this.serialPort.close();
        this.serialPort = null;
    }

    public void notifyReceiver() {
    }

    @Override
    public void serialEvent(SerialPortEvent serialPortEvent) {
        if (this.serialPort == null) {
            return;
        }
        switch (serialPortEvent.getEventType()) {
            case 10: {
                break;
            }
            case 7: {
                break;
            }
            case 9: {
                break;
            }
            case 8: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 1: {
                this.notifyReceiver();
                break;
            }
        }
    }

    @Override
    public void ownershipChange(int n) {
        switch (n) {
            case 2: {
                System.out.println(this.portID.getName() + ": PORT_UNOWNED");
                if (!this.waiting) break;
                this.initComPort();
                break;
            }
            case 1: {
                System.out.println(this.portID.getName() + ": PORT_OWNED");
                break;
            }
            case 3: {
                System.out.println(this.portID.getName() + ": PORT_OWNERSHIP_REQUESTED");
            }
        }
    }
}

