/*
 * Decompiled with CFR 0.152.
 */
package com.aql;

import com.aql.SensorPropertiesFrame;
import com.aql.rs232.CommPortCreator;
import com.aql.util.Command;
import com.aql.util.SensorCommand;
import com.aql.util.SensorParameters;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JOptionPane;

class SpanCalibrationThread
extends Thread {
    private SensorPropertiesFrame parent;
    private byte sensorID = 1;
    private CommPortCreator commPort;

    public SpanCalibrationThread(SensorPropertiesFrame sensorPropertiesFrame, byte by) {
        this.parent = sensorPropertiesFrame;
        this.sensorID = by;
        this.commPort = SensorPropertiesFrame.commPort;
    }

    @Override
    public void run() {
        try {
            InputStream inputStream = this.commPort.getInputStream();
            OutputStream outputStream = this.commPort.getOutputStream();
            inputStream.skip(inputStream.available());
            byte[] byArray = new byte[5];
            byArray[0] = 85;
            byArray[1] = 40;
            byArray[2] = this.sensorID;
            byArray[4] = SensorCommand.getCheckSum(byArray);
            System.out.println(SensorCommand.convertToHexString(byArray, 5));
            outputStream.write(byArray);
            outputStream.flush();
            byte[] byArray2 = new byte[52];
            int n = 0;
            int n2 = 0;
            while (inputStream.available() == 0 && n2++ < 5) {
                try {
                    Thread.sleep(300L);
                }
                catch (Exception exception) {}
            }
            System.out.println("buffer data:" + inputStream.available());
            if (inputStream.available() == 0) {
                this.parent.calibrationFailed();
                return;
            }
            n = 0;
            while (n < byArray2.length && n2++ < 10 && (n += inputStream.read(byArray2, n, byArray2.length - n)) != byArray2.length) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            System.out.println("received data:" + n);
            System.out.println(SensorCommand.convertToHexString(byArray2, 52));
            this.parent.closeProgress();
            if (n == byArray2.length && byArray2[0] == Command.SENSOR && SensorCommand.checkSumCorrect(byArray2)) {
                System.out.println("Param download success." + SensorCommand.convertToHexString(byArray2, byArray2.length));
                SensorParameters sensorParameters = new SensorParameters(this.toParamValue(byArray2));
                this.parent.setSensorParams(sensorParameters);
            } else {
                System.out.println("Param download failed, replied data corrupted.");
                JOptionPane.showMessageDialog(this.parent, "Get sensor gain failed, please try later.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private float[] toParamValue(byte[] byArray) {
        float[] fArray = new float[12];
        for (int i = 0; i < 12; ++i) {
            try {
                fArray[i] = SensorCommand.convertToValue(byArray, 2 + i * 4, 6 + i * 4);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return fArray;
    }
}

