/*
 * Decompiled with CFR 0.152.
 */
package com.aql;

import com.aql.ParaDownloadThread;
import com.aql.ParaUploadThread;
import com.aql.SensorPropertiesFrame;
import com.aql.util.SensorProperties;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;

public class SensorPropertiesPanel
extends JPanel {
    private ResourceBundle resources;
    private JComboBox unitFieldBox;
    private JSpinner rateField;
    private JSpinner ozoneMaxField;
    private JSpinner ozoneMinField;
    private JSpinner outputField;
    private JSpinner controlHiField;
    private JSpinner controlLoField;
    private JCheckBox defineOutputCheckBox;
    private JTextField idField;
    private JTextField idField2;
    private JRadioButton highRB;
    private JRadioButton lowRB;
    private JRadioButton enableRB;
    private JRadioButton disableRB;
    private JRadioButton defaultRB;
    private JRadioButton definedRB;
    private JTextField currentIdField;
    private JTextField defaultField;
    private JLabel ppmLabel;
    private JLabel scaleLabel;
    private JLabel ppmLabel2;
    private JLabel scaleLabel2;
    private SensorProperties sensor;

    public SensorPropertiesPanel(SensorProperties sensorProperties) {
        this.sensor = sensorProperties;
        try {
            this.initComp();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initComp() throws Exception {
        boolean bl = false;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.makeWarnPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 15, 0, 15), 0, 0));
    }

    public void setPortID(String string) {
        this.idField.setText(string);
    }

    private JPanel makeWarnPanel() throws Exception {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder("Configure Settings"));
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel("High alarm (ppm):");
        JLabel jLabel2 = new JLabel("Low alarm (ppm):");
        this.ozoneMaxField = new JSpinner(new SpinnerNumberModel(9.9, 0.001, 100000.0, 0.001));
        this.ozoneMinField = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 100000.0, 0.001));
        int n = 0;
        JLabel jLabel3 = new JLabel("Port ID :");
        this.idField = new JTextField();
        this.idField.setColumns(3);
        this.idField.setToolTipText("Please input integer value");
        this.idField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SensorPropertiesPanel.this.validIdField();
            }
        });
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 5), 0, 0));
        jPanel.add((Component)this.idField, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 25, 5, 10), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 5), 0, 0));
        jPanel.add((Component)this.ozoneMaxField, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 25, 5, 10), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 5), 0, 0));
        jPanel.add((Component)this.ozoneMinField, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 25, 5, 10), 0, 0));
        jLabel3 = new JLabel("Low alarm trigger:");
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 5), 0, 0));
        this.highRB = new JRadioButton("Above setpoint");
        this.highRB.setSelected(true);
        this.highRB.setMnemonic(65);
        this.highRB.setToolTipText("To select");
        jPanel.add((Component)this.highRB, new GridBagConstraints(1, n++, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 25, 0, 5), 0, 0));
        this.lowRB = new JRadioButton("Below setpoint");
        this.lowRB.setMnemonic(66);
        this.lowRB.setToolTipText("To select");
        jPanel.add((Component)this.lowRB, new GridBagConstraints(1, n++, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 25, 0, 5), 0, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.highRB);
        buttonGroup.add(this.lowRB);
        jLabel3 = new JLabel("Alarms: ");
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 5), 0, 0));
        this.enableRB = new JRadioButton("Enable");
        this.enableRB.setSelected(true);
        this.enableRB.setMnemonic(78);
        this.enableRB.setToolTipText("To select");
        jPanel.add((Component)this.enableRB, new GridBagConstraints(1, n++, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 25, 0, 5), 0, 0));
        this.disableRB = new JRadioButton("Disable");
        this.disableRB.setMnemonic(83);
        this.disableRB.setToolTipText("To select");
        jPanel.add((Component)this.disableRB, new GridBagConstraints(1, n++, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 25, 0, 5), 0, 0));
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.enableRB);
        buttonGroup.add(this.disableRB);
        JLabel jLabel4 = new JLabel("Control high (ppm):");
        JLabel jLabel5 = new JLabel("Control low (ppm):");
        this.controlHiField = new JSpinner(new SpinnerNumberModel(1.0, 0.001, 100000.0, 0.001));
        this.controlLoField = new JSpinner(new SpinnerNumberModel(0.5, 0.0, 100000.0, 0.001));
        jPanel.add((Component)jLabel4, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 5), 0, 0));
        jPanel.add((Component)this.controlHiField, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 25, 5, 10), 0, 0));
        jPanel.add((Component)jLabel5, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 5), 0, 0));
        jPanel.add((Component)this.controlLoField, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 25, 5, 10), 0, 0));
        jPanel.add((Component)this.outputPanel(), new GridBagConstraints(0, n++, 2, 1, 1.0, 0.0, 13, 2, new Insets(0, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.makeButtonPanel(), new GridBagConstraints(0, n, 2, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 10), 0, 0));
        return jPanel;
    }

    private JPanel outputPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder("4-20 mA output scale"));
        JLabel jLabel = new JLabel("4-20 mA output scale:");
        this.defaultRB = new JRadioButton(" Sensor default");
        this.defaultRB.setMnemonic(79);
        this.defaultRB.setToolTipText("To select");
        this.defaultRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SensorPropertiesPanel.this.setDefineEnabled(!SensorPropertiesPanel.this.defaultRB.isSelected());
                SensorPropertiesPanel.this.setDefaultEnabled(SensorPropertiesPanel.this.defaultRB.isSelected());
            }
        });
        jPanel.add((Component)this.defaultRB, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.scaleLabel = new JLabel(" 0 to ");
        jPanel.add((Component)this.scaleLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.defaultField = new JTextField("0.5");
        this.defaultField.setEditable(false);
        this.defaultField.setColumns(5);
        this.defaultField.setHorizontalAlignment(0);
        jPanel.add((Component)this.defaultField, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 2), 0, 0));
        this.ppmLabel = new JLabel("ppm");
        jPanel.add((Component)this.ppmLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.definedRB = new JRadioButton(" User defined");
        this.definedRB.setMnemonic(70);
        this.definedRB.setToolTipText("To select");
        this.definedRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SensorPropertiesPanel.this.setDefineEnabled(SensorPropertiesPanel.this.definedRB.isSelected());
                SensorPropertiesPanel.this.setDefaultEnabled(!SensorPropertiesPanel.this.definedRB.isSelected());
            }
        });
        jPanel.add((Component)this.definedRB, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.defaultRB);
        buttonGroup.add(this.definedRB);
        this.defaultRB.setSelected(true);
        this.scaleLabel2 = new JLabel(" 0 to ");
        jPanel.add((Component)this.scaleLabel2, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.outputField = new JSpinner(new SpinnerNumberModel(0.8, 0.001, 100000.0, 0.001));
        jPanel.add((Component)this.outputField, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 2), 0, 0));
        this.ppmLabel2 = new JLabel("ppm");
        jPanel.add((Component)this.ppmLabel2, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.setDefineEnabled(false);
        return jPanel;
    }

    private void validIdField() {
        int n = Integer.parseInt(this.idField.getText().trim());
        if (n > 255 || n == 0) {
            JOptionPane.showMessageDialog(this, "ID can not be Zero or greater than 255!!");
            this.idField.setText("1");
        }
    }

    private void setDefineEnabled(boolean bl) {
        this.scaleLabel2.setEnabled(bl);
        this.ppmLabel2.setEnabled(bl);
        this.outputField.setEnabled(bl);
    }

    private void setDefaultEnabled(boolean bl) {
        this.scaleLabel.setEnabled(bl);
        this.ppmLabel.setEnabled(bl);
        this.defaultField.setEnabled(bl);
    }

    private JPanel makeButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JButton jButton = new JButton("Download");
        jButton.setToolTipText("Download the port settings");
        jButton.setMnemonic(68);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SensorPropertiesPanel.this.doDownloadPara();
            }
        });
        jPanel.add((Component)jButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        JButton jButton2 = new JButton("Upload");
        jButton2.setToolTipText("Upload the port settings");
        jButton2.setMnemonic(85);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SensorPropertiesPanel.this.doUploadPara();
            }
        });
        jPanel.add((Component)jButton2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        return jPanel;
    }

    public SensorProperties getSensorProperties() {
        int n = Integer.parseInt(this.idField.getText().trim());
        if (n > 255 || n == 0) {
            JOptionPane.showMessageDialog(this, "ID can not be Zero or greater than 255!!");
            n = 1;
            this.idField.setText("" + n);
        }
        float f = (float)((Double)this.ozoneMaxField.getValue()).doubleValue();
        float f2 = (float)((Double)this.ozoneMinField.getValue()).doubleValue();
        boolean bl = this.enableRB.isSelected();
        SensorProperties sensorProperties = new SensorProperties(n, f, f2, bl, this.highRB.isSelected());
        sensorProperties.setUserDefined(this.definedRB.isSelected());
        sensorProperties.setControlHigh((float)((Double)this.controlHiField.getValue()).doubleValue());
        sensorProperties.setControlLow((float)((Double)this.controlLoField.getValue()).doubleValue());
        if (this.definedRB.isSelected()) {
            sensorProperties.setDefinedValue((float)((Double)this.outputField.getValue()).doubleValue());
        } else {
            sensorProperties.setDefinedValue(Float.parseFloat(this.defaultField.getText()));
        }
        return sensorProperties;
    }

    public void setSensorProperties(SensorProperties sensorProperties) {
        this.idField.setText("" + sensorProperties.getSensorId());
        this.ozoneMaxField.setValue(new Double(sensorProperties.getUpLimited()));
        this.ozoneMinField.setValue(new Double(sensorProperties.getBottomLimited()));
        this.controlHiField.setValue(new Double(sensorProperties.getControlHigh()));
        this.controlLoField.setValue(new Double(sensorProperties.getControlLow()));
        if (sensorProperties.getAlarmOn()) {
            this.enableRB.setSelected(true);
        } else {
            this.disableRB.setSelected(true);
        }
        if (sensorProperties.getA2TrigerHigh()) {
            this.highRB.setSelected(true);
        } else {
            this.lowRB.setSelected(true);
        }
        if (sensorProperties.isUserDefined()) {
            this.definedRB.setSelected(true);
            this.outputField.setValue(new Double(sensorProperties.getDefinedValue()));
            this.setDefineEnabled(true);
            this.setDefaultEnabled(false);
        } else {
            this.defaultRB.setSelected(true);
            this.setDefineEnabled(false);
            this.defaultField.setText("" + sensorProperties.getDefinedValue());
            this.setDefaultEnabled(true);
        }
    }

    private void doDownloadPara() {
        System.out.println("Start para downloading.....");
        new ParaDownloadThread(this, this.getSensorProperties()).start();
    }

    private void doUploadPara() {
        if (!SensorPropertiesFrame.commPort.isPortOpenned()) {
            JOptionPane.showMessageDialog(this, "COMM port used by other application!\nReset COMM port then try again.");
            return;
        }
        String string = "You are going to upload current port settings to port 0x" + this.idField.getText();
        int n = JOptionPane.showConfirmDialog(this, string);
        if (n != 0) {
            return;
        }
        new ParaUploadThread(this, this.getSensorProperties()).start();
    }
}

