/*
 * Decompiled with CFR 0.152.
 */
package com.aql;

import com.aql.PollReadingThread;
import com.aql.PortSetupDialog;
import com.aql.ProgressWindow;
import com.aql.SensorPropertiesPanel;
import com.aql.SpanCalibrationThread;
import com.aql.SplashWin;
import com.aql.ZeroCalibrationThread;
import com.aql.rs232.CommPortCreator;
import com.aql.rs232.SensorParameterUploadThread;
import com.aql.util.Command;
import com.aql.util.SearchNetworkThread;
import com.aql.util.SensorCommand;
import com.aql.util.SensorParameters;
import com.aql.util.SensorProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.TitledBorder;

public class SensorPropertiesFrame
extends JFrame {
    private SensorProperties sensor;
    private ResourceBundle resources;
    public static CommPortCreator commPort;
    private JSpinner ozoneMaxField;
    private JSpinner ozoneMinField;
    private JCheckBox alarmEnableBox;
    private JButton okButton;
    private JButton cancelButton;
    private JTextField currentIdField;
    private JTextField newField;
    private SensorPropertiesPanel propertiesPanel;
    private ProgressWindow progressWin;

    public SensorPropertiesFrame(SensorProperties sensorProperties) {
        commPort = new CommPortCreator();
        this.sensor = sensorProperties;
        this.initComp();
        this.setComponentLocation(this);
    }

    public void setComponentLocation(Component component) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = component.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        component.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    private void initComp() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            System.err.println("theme" + unsupportedLookAndFeelException.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.resources = ResourceBundle.getBundle("resources.ozonebundles", Locale.getDefault());
        this.setTitle(this.resources.getString("version"));
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/resources/sensorhead.GIF"));
        this.setIconImage(imageIcon.getImage());
        this.buildMenuBar();
        this.getContentPane().setLayout(new BorderLayout());
        this.propertiesPanel = new SensorPropertiesPanel(this.sensor);
        this.propertiesPanel.setSensorProperties(this.sensor);
        this.getContentPane().add((Component)this.propertiesPanel, "Center");
        this.getContentPane().add((Component)this.makeButtonPanel(), "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SensorPropertiesFrame.this.okButtonActionPerformed();
            }
        });
        this.pack();
    }

    private void buildMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("System");
        jMenu.setMnemonic('y');
        JMenuItem jMenuItem = new JMenuItem("COM settings...");
        jMenuItem.setMnemonic('m');
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SensorPropertiesFrame.this.setupCommPort();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Exit");
        jMenuItem.setMnemonic('E');
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SensorPropertiesFrame.this.okButtonActionPerformed();
            }
        });
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Port");
        jMenu.setMnemonic('P');
        jMenuItem = new JMenuItem("Search port");
        jMenuItem.setMnemonic('r');
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SensorPropertiesFrame.this.searchID();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Change port ID");
        jMenuItem.setMnemonic('C');
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SensorPropertiesFrame.this.changeID();
            }
        });
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Tools");
        jMenu.setMnemonic('T');
        jMenuItem = new JMenuItem("Zero Calibration");
        jMenuItem.setMnemonic('Z');
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SensorPropertiesFrame.this.doZeroCalibration();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Span Calibration");
        jMenuItem.setMnemonic('S');
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SensorPropertiesFrame.this.doSpanCalibration();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        JMenu jMenu2 = new JMenu("Check Readings");
        jMenuItem = new JMenuItem("S900");
        jMenuItem.setMnemonic('h');
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SensorPropertiesFrame.this.pollReading();
            }
        });
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("S905 with temperature/RH");
        jMenuItem.setMnemonic('t');
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SensorPropertiesFrame.this.pollReadingWithSHT();
            }
        });
        jMenu2.add(jMenuItem);
        jMenu.add(jMenu2);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("View Sensor Head Info");
        jMenuItem.setMnemonic('S');
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SensorPropertiesFrame.this.viewSensorHead();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("View S900 Version");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SensorPropertiesFrame.this.viewS900Version();
            }
        });
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
    }

    private void doZeroCalibration() {
        if (!commPort.isPortOpenned()) {
            JOptionPane.showMessageDialog(this, "COMM port used by other application!\nReset COMM port then try again.");
            return;
        }
        int n = JOptionPane.showConfirmDialog(this, "Are you sure you want to do zero calibration?", "Zero Calibration", 0);
        if (n == 0) {
            System.out.println("Start calibration...");
            this.progressWin = new ProgressWindow(this, "Zero Calibrating, please wait...");
            new ZeroCalibrationThread(this, (byte)this.propertiesPanel.getSensorProperties().getSensorId()).start();
        }
    }

    private void doSpanCalibration() {
        if (!commPort.isPortOpenned()) {
            JOptionPane.showMessageDialog(this, "COMM port used by other application!\nReset COMM port then try again.");
            return;
        }
        System.out.println("Start calibration...");
        this.progressWin = new ProgressWindow(this, "Span Calibrating, please wait...");
        new SpanCalibrationThread(this, (byte)this.propertiesPanel.getSensorProperties().getSensorId()).start();
    }

    public void setSensorParams(SensorParameters sensorParameters) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel("Current Reading (ppm): ");
        JTextField jTextField = new JTextField("Reading");
        jTextField.setEditable(false);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)jTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        jLabel = new JLabel("Current Gain Factor: ");
        JTextField jTextField2 = new JTextField();
        jTextField2.setEditable(false);
        jTextField2.setText("" + sensorParameters.getParameters()[11]);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)jTextField2, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        jLabel = new JLabel("New Gain Factor: ");
        JTextField jTextField3 = new JTextField();
        jTextField3.setText("" + sensorParameters.getParameters()[11]);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)jTextField3, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        PollReadingThread pollReadingThread = new PollReadingThread((byte)this.propertiesPanel.getSensorProperties().getSensorId(), new JLabel(""), jTextField);
        pollReadingThread.start();
        int n = JOptionPane.showConfirmDialog(this, jPanel, "Calibrate Gain", 2);
        pollReadingThread.stopPolling();
        if (n == 0) {
            System.out.println("Calibrate gain factor");
            this.progressWin = new ProgressWindow(this, "Calibrating gain factor, please wait...");
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                float f = Float.parseFloat(jTextField3.getText().trim());
                sensorParameters.setFieldValue(11, f);
                new SensorParameterUploadThread(this, (byte)this.propertiesPanel.getSensorProperties().getSensorId(), sensorParameters).start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void closeProgress() {
        if (this.progressWin != null) {
            this.progressWin.dispose();
        }
    }

    public void calibrationFinished() {
        this.progressWin.dispose();
        JOptionPane.showMessageDialog(this, "The calibration finished!");
    }

    public void calibrationFailed() {
        this.progressWin.dispose();
        JOptionPane.showMessageDialog(this, "The calibration was not successful!\n Please check connections and power!");
    }

    private void pollReading() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel("Gas Conc:");
        JTextField jTextField = new JTextField(5);
        jTextField.setText("reading");
        JLabel jLabel2 = new JLabel("ppm");
        jTextField.setEditable(false);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)jTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        PollReadingThread pollReadingThread = new PollReadingThread((byte)this.propertiesPanel.getSensorProperties().getSensorId(), jLabel, jTextField);
        pollReadingThread.start();
        JOptionPane.showMessageDialog(this, jPanel, "Check Readings", 1);
        pollReadingThread.stopPolling();
    }

    private void pollReadingWithSHT() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel("Gas Conc:");
        JTextField jTextField = new JTextField(5);
        jTextField.setText("reading");
        JLabel jLabel2 = new JLabel("ppm");
        jTextField.setEditable(false);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)jTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        JLabel jLabel3 = new JLabel("Temp :");
        JTextField jTextField2 = new JTextField(5);
        jTextField2.setText("reading");
        jLabel2 = new JLabel("C");
        jTextField2.setEditable(false);
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)jTextField2, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        jLabel3 = new JLabel("RH :");
        JTextField jTextField3 = new JTextField(5);
        jTextField3.setText("reading");
        jLabel2 = new JLabel("%");
        jTextField3.setEditable(false);
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)jTextField3, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        PollReadingThread pollReadingThread = new PollReadingThread((byte)this.propertiesPanel.getSensorProperties().getSensorId(), jLabel, jTextField, jTextField2, jTextField3);
        pollReadingThread.start();
        JOptionPane.showMessageDialog(this, jPanel, "Check Readings", 1);
        pollReadingThread.stopPolling();
    }

    private void viewSensorHead() {
        try {
            InputStream inputStream = commPort.getInputStream();
            OutputStream outputStream = commPort.getOutputStream();
            byte[] byArray = new byte[5];
            byte[] byArray2 = new byte[15];
            byArray[0] = 85;
            byArray[1] = -5;
            byArray[2] = (byte)this.propertiesPanel.getSensorProperties().getSensorId();
            byArray[4] = SensorCommand.getCheckSum(byArray);
            System.out.println(SensorCommand.convertToHexString(byArray, 5));
            outputStream.write(byArray);
            outputStream.flush();
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            inputStream.read(byArray2);
            System.out.println(SensorCommand.convertToHexString(byArray2, 15));
            String string = new String(byArray2, 6, (int)byArray2[5]);
            String string2 = "" + (float)byArray2[3] / 10.0f;
            byArray[1] = Command.SENSOR_FACTOR_REQUEST;
            byArray[4] = SensorCommand.getCheckSum(byArray);
            System.out.println(SensorCommand.convertToHexString(byArray, 5));
            outputStream.write(byArray);
            outputStream.flush();
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            inputStream.read(byArray2);
            System.out.println(SensorCommand.convertToHexString(byArray2, 15));
            float f = SensorCommand.convertToValue(byArray2, 2, 6);
            float f2 = SensorCommand.convertToValue(byArray2, 6, 10);
            String string3 = "Sensor Name: " + string + "\nVersion: " + string2 + "\nppm - mg/m3 convert factor: " + f + "\nDefault output scale: " + f2 + " ppm";
            JOptionPane.showMessageDialog(this, string3, "Sensor head info", 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void viewS900Version() {
        try {
            InputStream inputStream = commPort.getInputStream();
            OutputStream outputStream = commPort.getOutputStream();
            byte[] byArray = new byte[5];
            byte[] byArray2 = new byte[15];
            byArray[0] = 85;
            byArray[1] = Command.S900_INFO;
            byArray[2] = (byte)this.propertiesPanel.getSensorProperties().getSensorId();
            byArray[4] = SensorCommand.getCheckSum(byArray);
            System.out.println(SensorCommand.convertToHexString(byArray, 5));
            outputStream.write(byArray);
            outputStream.flush();
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            inputStream.read(byArray2);
            System.out.println(SensorCommand.convertToHexString(byArray2, 15));
            String string = "" + (float)byArray2[3] / 10.0f;
            String string2 = "S900 Version: " + string;
            JOptionPane.showMessageDialog(this, string2, "S900 info", 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void searchID() {
        if (!commPort.isPortOpenned()) {
            JOptionPane.showMessageDialog(this, "COMM port used by other application!\nReset COMM port then try again.");
            return;
        }
        new SearchNetworkThread(this).start();
    }

    public void setFoundID(int n) {
        String string = Integer.toString(n);
        this.propertiesPanel.setPortID(string);
    }

    private JPanel makeButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        this.okButton = new JButton();
        this.okButton.setText("Exit");
        this.okButton.setMnemonic(69);
        this.okButton.setToolTipText("Close the configure window");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SensorPropertiesFrame.this.okButtonActionPerformed();
            }
        });
        jPanel.add((Component)this.okButton, new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        return jPanel;
    }

    private void setupCommPort() {
        System.out.println("Show set up comm port dialog...");
        PortSetupDialog portSetupDialog = new PortSetupDialog(this, true);
        this.setComponentLocation(portSetupDialog);
        portSetupDialog.setVisible(true);
    }

    private void changeID() {
        try {
            int n = JOptionPane.showConfirmDialog(this, this.changeIdPanel(), "Change ID", 0);
            if (n == 0) {
                this.doSetPortID();
                System.out.println("changed...");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private JPanel changeIdPanel() throws Exception {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder("Change S900 ID"));
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel("Current ID: ");
        this.currentIdField = new JTextField("" + this.propertiesPanel.getSensorProperties().getSensorId());
        this.currentIdField.setColumns(3);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        jPanel.add((Component)this.currentIdField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        jLabel = new JLabel("New ID: ");
        this.newField = new JTextField();
        this.newField.setColumns(3);
        this.newField.setToolTipText("Please input integer value");
        this.newField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                SensorPropertiesFrame.this.newField.setCaretPosition(0);
            }
        });
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        jPanel.add((Component)this.newField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        JButton jButton = new JButton("Change ID");
        jButton.setMnemonic(67);
        jButton.setToolTipText("Change port ID to new ID");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SensorPropertiesFrame.this.doSetPortID();
            }
        });
        return jPanel;
    }

    private void doSetPortID() {
        try {
            byte[] byArray;
            try {
                if (this.currentIdField.getText().trim().equals("") || this.newField.getText().trim().equals("")) {
                    JOptionPane.showMessageDialog(this, "ID can not be empty!!");
                    this.changeID();
                    return;
                }
                if (Integer.parseInt(this.newField.getText().trim()) > 255 || Integer.parseInt(this.newField.getText().trim()) == 0) {
                    JOptionPane.showMessageDialog(this, "ID can not be Zero or greater than 255!!");
                    this.changeID();
                    return;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            String string = "You are going to change the port ID: " + this.currentIdField.getText() + " to " + this.newField.getText();
            int n = JOptionPane.showConfirmDialog(this, string);
            if (n != 0) {
                return;
            }
            byArray = new byte[]{85, Command.SET_NETWORK_ID, (byte)Integer.parseInt(this.currentIdField.getText().trim()), (byte)Integer.parseInt(this.newField.getText().trim()), SensorCommand.getCheckSum(byArray)};
            System.out.println("Change ID Command: " + SensorCommand.convertToHexString(byArray, 5));
            OutputStream outputStream = commPort.getOutputStream();
            outputStream.flush();
            outputStream.write(byArray);
            outputStream.flush();
            byte[] byArray2 = new byte[15];
            byte[] byArray3 = new byte[1];
            int n2 = 0;
            InputStream inputStream = commPort.getInputStream();
            boolean bl = false;
            for (int i = 0; i < 10; ++i) {
                while (inputStream.available() > 0) {
                    if (byArray3[0] == Command.SENSOR) {
                        byArray2[0] = byArray3[0];
                        for (n2 = inputStream.read(byArray3); n2 < byArray2.length; n2 += inputStream.read(byArray2, n2, byArray2.length - n2)) {
                        }
                        System.out.println("Set ID reply: " + SensorCommand.convertToHexString(byArray2, n2) + " The data length got:" + n2 + " bytes");
                        if (n2 != byArray2.length) continue;
                        bl = true;
                        break;
                    }
                    System.out.println("Communication not synchronised...");
                }
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.out.println("Connection test waiting for reply..." + i);
                if (bl) break;
            }
            if (bl) {
                this.propertiesPanel.setPortID(this.newField.getText().trim());
                JOptionPane.showMessageDialog(this, "Port ID changed successful.");
            } else {
                JOptionPane.showMessageDialog(this, "Change Port ID failed !!!");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void okButtonActionPerformed() {
        this.dispose();
        System.exit(0);
    }

    public void reconfigPort() {
        commPort.initComPort();
    }

    public static void main(String[] stringArray) {
        SplashWin splashWin = new SplashWin();
        splashWin.setVisible(true);
        SensorPropertiesFrame sensorPropertiesFrame = new SensorPropertiesFrame(new SensorProperties());
        sensorPropertiesFrame.setVisible(true);
        splashWin.dispose();
    }
}

