/*
 * Decompiled with CFR 0.152.
 */
package com.aql;

import com.aql.SensorPropertiesFrame;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.comm.CommPortIdentifier;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class PortSetupDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private SensorPropertiesFrame parent;
    private ResourceBundle resources;
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel jPanel1;
    private JLabel jLabel1;
    private JComboBox jComboBox1;
    private JLabel jLabel2;
    private JComboBox jComboBox2;
    private JLabel jLabel3;
    private JComboBox jComboBox3;
    private JLabel jLabel4;
    private JComboBox jComboBox4;
    private JLabel jLabel5;
    private JComboBox jComboBox5;
    private JLabel jLabel6;
    private JComboBox jComboBox6;
    private String[] baudRate = new String[]{"110", "300", "600", "1200", "2400", "4800", "9600", "14400", "19200", "38400", "56000", "57600", "115200", "128000", "256000"};
    private String[] parity = new String[5];
    private int returnStatus = 0;

    public PortSetupDialog(SensorPropertiesFrame sensorPropertiesFrame, boolean bl) {
        super((Frame)sensorPropertiesFrame, bl);
        this.parent = sensorPropertiesFrame;
        this.resources = ResourceBundle.getBundle("resources.ozonebundles", Locale.getDefault());
        this.initComponents();
        this.initComboBox();
        this.pack();
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jComboBox2 = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jComboBox3 = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jComboBox4 = new JComboBox();
        this.jLabel5 = new JLabel();
        this.jComboBox5 = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jComboBox6 = new JComboBox();
        this.jComboBox2.setEnabled(false);
        this.jComboBox3.setEnabled(false);
        this.jComboBox4.setEnabled(false);
        this.jComboBox5.setEnabled(false);
        this.jComboBox6.setEnabled(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle(this.resources.getString("main.frame.menu.setting"));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PortSetupDialog.this.closeDialog(windowEvent);
            }
        });
        this.buttonPanel.setLayout(new FlowLayout(2, 5, 5));
        this.okButton.setText(this.resources.getString("button.ok"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PortSetupDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.okButton.setMnemonic(79);
        this.cancelButton.setText(this.resources.getString("button.cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PortSetupDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.cancelButton.setMnemonic(67);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(new TitledBorder(this.resources.getString("comm.port.dialog.title")));
        this.jLabel1.setText(this.resources.getString("comm.port.dialog.port.label"));
        this.jLabel1.setHorizontalAlignment(2);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints2.anchor = 17;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(5, 0, 0, 5);
        this.jPanel1.add((Component)this.jComboBox1, gridBagConstraints2);
        this.jLabel2.setText(this.resources.getString("comm.port.dialog.baud.rate.label"));
        this.jLabel2.setHorizontalAlignment(2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints2.anchor = 17;
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(5, 0, 0, 5);
        this.jPanel1.add((Component)this.jComboBox2, gridBagConstraints2);
        this.jLabel3.setText(this.resources.getString("comm.port.dialog.data.bits.label"));
        this.jLabel3.setHorizontalAlignment(2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints2.anchor = 17;
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(5, 0, 0, 5);
        this.jPanel1.add((Component)this.jComboBox3, gridBagConstraints2);
        this.jLabel4.setText(this.resources.getString("comm.port.dialog.stop.bits.label"));
        this.jLabel4.setHorizontalAlignment(2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints2.anchor = 17;
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(5, 0, 0, 5);
        this.jPanel1.add((Component)this.jComboBox4, gridBagConstraints2);
        this.jLabel5.setText(this.resources.getString("comm.port.dialog.parity.label"));
        this.jLabel5.setHorizontalAlignment(2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 4;
        gridBagConstraints2.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints2.anchor = 17;
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 4;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(5, 0, 0, 5);
        this.jPanel1.add((Component)this.jComboBox5, gridBagConstraints2);
        this.jLabel6.setText(this.resources.getString("comm.port.dialog.flow.control.label"));
        this.jLabel6.setHorizontalAlignment(2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 5;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints2.anchor = 17;
        this.jPanel1.add((Component)this.jLabel6, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 5;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(5, 0, 5, 5);
        this.jPanel1.add((Component)this.jComboBox6, gridBagConstraints2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
    }

    private void initComboBox() {
        int n;
        Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
        while (enumeration.hasMoreElements()) {
            CommPortIdentifier commPortIdentifier = (CommPortIdentifier)enumeration.nextElement();
            if (commPortIdentifier.getPortType() != 1) continue;
            this.jComboBox1.addItem(commPortIdentifier.getName());
        }
        for (n = 0; n < this.baudRate.length; ++n) {
            this.jComboBox2.addItem(this.baudRate[n]);
        }
        this.jComboBox2.setSelectedIndex(4);
        for (n = 5; n < 9; ++n) {
            this.jComboBox3.addItem("" + n);
        }
        this.jComboBox3.setSelectedIndex(3);
        this.jComboBox4.addItem("1");
        this.jComboBox4.addItem("1.5");
        this.jComboBox4.addItem("2");
        for (n = 0; n < this.parity.length; ++n) {
            this.parity[n] = this.resources.getString("comm.port.parity.item" + n);
            this.jComboBox5.addItem(this.parity[n]);
        }
        this.jComboBox6.addItem(this.resources.getString("label.none"));
        this.jComboBox6.addItem(this.resources.getString("label.hardware"));
        this.jComboBox6.addItem(this.resources.getString("label.software") + "           ");
        this.loadPortConfig();
    }

    private void loadPortConfig() {
        try {
            Properties properties = new Properties();
            File file = new File(".");
            String string = file.getAbsolutePath() + "\\resources\\";
            FileInputStream fileInputStream = new FileInputStream(string + "parameter.ini");
            properties.load(fileInputStream);
            Object object = properties.get("port");
            this.jComboBox1.setSelectedItem(object);
            object = properties.get("baud_rate");
            this.jComboBox2.setSelectedItem(object);
            object = properties.get("data_bits");
            this.jComboBox3.setSelectedItem(object);
            object = properties.get("stop_bits");
            this.jComboBox4.setSelectedItem(object);
            object = properties.get("parity");
            this.jComboBox5.setSelectedItem(object);
            object = properties.get("flow_control");
            this.jComboBox6.setSelectedItem(object);
            fileInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.storeConfig();
        this.parent.reconfigPort();
        this.doClose(1);
    }

    private void storeConfig() {
        try {
            Properties properties = new Properties();
            properties.put("port", this.jComboBox1.getSelectedItem());
            properties.put("baud_rate", this.jComboBox2.getSelectedItem());
            properties.put("data_bits", this.jComboBox3.getSelectedItem());
            properties.put("stop_bits", this.jComboBox4.getSelectedItem());
            properties.put("parity", this.jComboBox5.getSelectedItem());
            properties.put("flow_control", this.jComboBox6.getSelectedItem());
            File file = new File(".");
            String string = file.getAbsolutePath() + "\\resources\\";
            FileOutputStream fileOutputStream = new FileOutputStream(string + "parameter.ini");
            properties.store(fileOutputStream, "Com port properties of the system");
            fileOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose(0);
    }

    private void doClose(int n) {
        this.returnStatus = n;
        this.setVisible(false);
        this.dispose();
    }
}

