/*
 * Decompiled with CFR 0.152.
 */
package com.aql;

import com.aql.SensorPropertiesFrame;
import com.aql.rs232.CommPortCreator;
import com.aql.util.Command;
import com.aql.util.SensorCommand;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JTextField;

class PollReadingThread
extends Thread {
    private boolean stopPolling = false;
    private byte sensorID = 1;
    private CommPortCreator commPort;
    private JLabel label;
    private JTextField readingField;
    private JTextField tempField;
    private JTextField rhField;
    private NumberFormat formater = NumberFormat.getInstance();

    public PollReadingThread(byte by, JLabel jLabel, JTextField jTextField) {
        this(by, jLabel, jTextField, null, null);
    }

    public PollReadingThread(byte by, JLabel jLabel, JTextField jTextField, JTextField jTextField2, JTextField jTextField3) {
        this.sensorID = by;
        this.label = jLabel;
        this.readingField = jTextField;
        this.tempField = jTextField2;
        this.rhField = jTextField3;
        this.commPort = SensorPropertiesFrame.commPort;
        this.formater.setMinimumFractionDigits(3);
        this.formater.setMaximumFractionDigits(3);
    }

    @Override
    public void run() {
        try {
            InputStream inputStream = this.commPort.getInputStream();
            OutputStream outputStream = this.commPort.getOutputStream();
            byte[] byArray = new byte[5];
            byte[] byArray2 = new byte[15];
            inputStream.skip(inputStream.available());
            byArray[0] = 85;
            byArray[1] = -5;
            byArray[2] = this.sensorID;
            byArray[4] = SensorCommand.getCheckSum(byArray);
            System.out.println(SensorCommand.convertToHexString(byArray, 5));
            outputStream.write(byArray);
            outputStream.flush();
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            inputStream.read(byArray2);
            System.out.println(SensorCommand.convertToHexString(byArray2, 15));
            String string = new String(byArray2, 6, (int)byArray2[5]);
            this.label.setText(string + ":");
            switch (byArray2[4]) {
                case 1: {
                    this.formater.setMinimumFractionDigits(3);
                    this.formater.setMaximumFractionDigits(3);
                    break;
                }
                case 2: {
                    this.formater.setMinimumFractionDigits(2);
                    this.formater.setMaximumFractionDigits(2);
                    break;
                }
                case 3: {
                    this.formater.setMinimumFractionDigits(1);
                    this.formater.setMaximumFractionDigits(1);
                    break;
                }
                case 4: {
                    this.formater.setMinimumFractionDigits(0);
                    this.formater.setMaximumFractionDigits(0);
                    break;
                }
                default: {
                    this.formater.setMinimumFractionDigits(3);
                    this.formater.setMaximumFractionDigits(3);
                }
            }
            int n = 0;
            byArray[0] = 85;
            byArray[1] = 26;
            byArray[2] = this.sensorID;
            byArray[4] = SensorCommand.getCheckSum(byArray);
            while (!this.stopPolling) {
                inputStream.skip(inputStream.available());
                System.out.println(SensorCommand.convertToHexString(byArray, 5));
                outputStream.write(byArray);
                outputStream.flush();
                for (n = 0; n < byArray2.length; n += inputStream.read(byArray2, n, byArray2.length - n)) {
                }
                System.out.println(SensorCommand.convertToHexString(byArray2, 15));
                if (byArray2[0] == Command.SENSOR && byArray2[1] == 16) {
                    float f = SensorCommand.convertToValue(byArray2, 2, 6);
                    this.readingField.setText(this.formater.format(f));
                    if (this.tempField != null) {
                        int n2 = byArray2[8];
                        n2 = n2 << 8 | byArray2[7] & 0xFF;
                        this.tempField.setText("" + (float)n2 / 10.0f);
                        n2 = byArray2[10] & 0xFF;
                        n2 = n2 << 8 | byArray2[9] & 0xFF;
                        this.rhField.setText("" + (float)n2 / 10.0f);
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void stopPolling() {
        this.stopPolling = true;
    }
}

