/*
 * Decompiled with CFR 0.152.
 */
package com.aql;

import com.aql.SensorPropertiesFrame;
import com.aql.SensorPropertiesPanel;
import com.aql.rs232.CommPortCreator;
import com.aql.util.Command;
import com.aql.util.SensorCommand;
import com.aql.util.SensorProperties;
import java.io.InputStream;
import javax.swing.JOptionPane;

class ParaUploadThread
extends Thread {
    private SensorPropertiesPanel parent;
    private CommPortCreator commPort;
    private SensorProperties sensor;
    private boolean stop = false;

    public ParaUploadThread(SensorPropertiesPanel sensorPropertiesPanel, SensorProperties sensorProperties) {
        this.parent = sensorPropertiesPanel;
        this.commPort = SensorPropertiesFrame.commPort;
        this.sensor = sensorProperties;
    }

    @Override
    public void run() {
        System.out.println("start upload para...");
        try {
            int n;
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            InputStream inputStream = this.commPort.getInputStream();
            inputStream.skip(inputStream.available());
            SensorCommand.sendCommand(new SensorCommand(25, this.sensor));
            byte[] byArray = new byte[25];
            int n2 = 0;
            byArray[0] = 85;
            byArray[1] = 25;
            byArray[2] = (byte)this.sensor.getSensorId();
            byte[] byArray2 = SensorCommand.toByteArray(this.sensor.getUpLimited());
            for (n = 0; n < 4; ++n) {
                byArray[3 + n] = byArray2[n];
            }
            byArray2 = SensorCommand.toByteArray(this.sensor.getBottomLimited());
            for (n = 0; n < 4; ++n) {
                byArray[7 + n] = byArray2[n];
            }
            byArray2 = SensorCommand.toByteArray(this.sensor.getDefinedValue());
            for (n = 0; n < 4; ++n) {
                byArray[11 + n] = byArray2[n];
            }
            byArray2 = SensorCommand.toByteArray(this.sensor.getControlHigh());
            for (n = 0; n < 4; ++n) {
                byArray[15 + n] = byArray2[n];
            }
            byArray2 = SensorCommand.toByteArray(this.sensor.getControlLow());
            for (n = 0; n < 4; ++n) {
                byArray[19 + n] = byArray2[n];
            }
            n = 0;
            if (!this.sensor.getAlarmOn()) {
                n = (byte)(n | 1);
            }
            if (!this.sensor.getA2TrigerHigh()) {
                n = (byte)(n | 2);
            }
            if (this.sensor.isUserDefined()) {
                n = (byte)(n | 4);
            }
            byArray[23] = n;
            byArray[24] = SensorCommand.getCheckSum(byArray);
            System.out.println("The para upload: " + SensorCommand.convertToHexString(byArray, byArray.length));
            this.commPort.getOutputStream().write(byArray);
            this.commPort.getOutputStream().flush();
            byArray = new byte[15];
            boolean bl = false;
            for (int i = 0; i < 10; ++i) {
                while (inputStream.available() > 0) {
                    if (byArray[0] == Command.SENSOR) {
                        for (n2 = inputStream.read(byArray, 0, 1); n2 < byArray.length; n2 += inputStream.read(byArray, n2, byArray.length - n2)) {
                        }
                        System.out.println("para upload reply: " + SensorCommand.convertToHexString(byArray, n2) + " The data length got:" + n2 + " bytes");
                        if (n2 != byArray.length) continue;
                        bl = true;
                        break;
                    }
                    System.out.println("Communication not synchronised...");
                }
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.out.println("uploading waiting for reply..." + i);
                if (bl) break;
            }
            if (!bl) {
                JOptionPane.showMessageDialog(this.parent, "Port settings upload for port ID: " + this.sensor.getSensorId() + " failed!!");
                return;
            }
            if (byArray[0] != SensorCommand.SENSOR || !SensorCommand.checkSumCorrect(byArray)) {
                this.run();
                return;
            }
            JOptionPane.showMessageDialog(this.parent, "Port settings upload successful.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

