/*
 * Decompiled with CFR 0.152.
 */
package com.aql;

import com.aql.SensorPropertiesFrame;
import com.aql.SensorPropertiesPanel;
import com.aql.rs232.CommPortCreator;
import com.aql.util.Command;
import com.aql.util.SensorCommand;
import com.aql.util.SensorProperties;
import java.io.InputStream;
import javax.swing.JOptionPane;

class ParaDownloadThread
extends Thread {
    private SensorPropertiesPanel parent;
    private CommPortCreator commPort;
    private SensorProperties sensor;
    private boolean stop = false;

    public ParaDownloadThread(SensorPropertiesPanel sensorPropertiesPanel, SensorProperties sensorProperties) {
        this.parent = sensorPropertiesPanel;
        this.commPort = SensorPropertiesFrame.commPort;
        this.sensor = sensorProperties;
    }

    @Override
    public void run() {
        try {
            if (!this.commPort.isPortOpenned()) {
                JOptionPane.showMessageDialog(this.parent, "COMM port used by other application!\nReset COMM port then try again.");
                return;
            }
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            InputStream inputStream = this.commPort.getInputStream();
            inputStream.skip(inputStream.available());
            SensorCommand.sendCommand(new SensorCommand(24, this.sensor));
            byte[] byArray = new byte[25];
            int n = 0;
            boolean bl = false;
            for (int i = 0; i < 10; ++i) {
                while (inputStream.available() > 0) {
                    if (byArray[0] == Command.SENSOR) {
                        for (n = inputStream.read(byArray, 0, 1); n < byArray.length; n += inputStream.read(byArray, n, byArray.length - n)) {
                        }
                        System.out.println("para download reply: " + SensorCommand.convertToHexString(byArray, n) + " The data length got:" + n + " bytes");
                        if (n != byArray.length) continue;
                        bl = true;
                        break;
                    }
                    System.out.println("Communication not synchronised...");
                }
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.out.println("downloading waiting for reply..." + i);
                if (bl) break;
            }
            if (!bl) {
                JOptionPane.showMessageDialog(this.parent, "Port ID: " + this.sensor.getSensorId() + " not found!!");
                return;
            }
            if (byArray[0] != Command.SENSOR || !SensorCommand.checkSumCorrect(byArray)) {
                this.run();
                return;
            }
            float f = SensorCommand.convertToValue(byArray, 2, 6);
            float f2 = SensorCommand.convertToValue(byArray, 6, 10);
            float f3 = SensorCommand.convertToValue(byArray, 10, 14);
            float f4 = SensorCommand.convertToValue(byArray, 14, 18);
            float f5 = SensorCommand.convertToValue(byArray, 18, 22);
            byte by = byArray[23];
            boolean bl2 = true;
            boolean bl3 = true;
            boolean bl4 = false;
            if ((by & 1) == 1) {
                bl2 = false;
            }
            if ((by & 2) == 2) {
                bl3 = false;
            }
            if ((by & 4) == 4) {
                bl4 = true;
            }
            SensorProperties sensorProperties = new SensorProperties(this.sensor.getSensorId(), f, f2, bl2, bl3);
            sensorProperties.setUserDefined(bl4);
            sensorProperties.setDefinedValue(f3);
            sensorProperties.setControlHigh(f4);
            sensorProperties.setControlLow(f5);
            this.parent.setSensorProperties(sensorProperties);
            JOptionPane.showMessageDialog(this.parent, "Port settings download successful.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

